<?php
/*********************************************************************************************
+ Private Threads v0.1 : A Plugin for MyBB 1.4 and 1.6
+ Free to Use
+ Free to Edit
+ But Not Allowed to distribute
+ arabic support www.mybbarab.com
**********************************************************************************************
*/
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

function private_threads_info()
{
	return array(
		"name"			=> "هاك منع الرد لمجموعة اعضاء",
		"description"	=> "تستطيع منع مجموعة اعضاء معينه في اقسام معينة من الرد",
		"website"		=> "http://yaldaram.com",
		"author"		=> "Yaldaram",
		"authorsite"	=> "http://yaldaram.com",
		"version"		=> "0.1",
		"compatibility" => "14*,16*"
	);

}
function private_threads_install()
{
	global $db, $mybb;

	$private_threads_group = array(
		"gid"			=> "NULL",
		"name"			=> "private_threads",
		"title" 		=> "هاك منع الاعضاء من الرد",
		"description"	=> "اعدادات الهاك",
		"disporder"		=> "1",
		"isdefault"		=> "no",
	);
	$db->insert_query("settinggroups", $private_threads_group);
	$gid = $db->insert_id();
	
	$private_threads_setting_1 = array(
		"sid"			=> "NULL",
		"name"			=> "private_threads_power",
		"title"			=> "فتح / اغلاق",
		"description"	=> "تستطيع فتح او اغلاق الهاك من هنا",
		"optionscode"	=> "yesno",
		"value"			=> "1",
		"disporder"		=> "1",
		"gid"			=> intval($gid),
	);

	$db->insert_query("settings", $private_threads_setting_1);

	$private_threads_setting_2 = array(
		"sid"			=> "NULL",
		"name"			=> "private_threads_group",
		"title"			=> "المجموعات الممنوعة",
		"description"	=> "ضع هنا ارقام المجموعات الممنوعة من وضع ردود في الاقسام التي يتم تحديدها .",
		"optionscode"	=> "text",
		"value"			=> "1,2,5",
		"disporder"		=> "2",
		"gid"			=> intval($gid),
	);

	$db->insert_query("settings", $private_threads_setting_2);
	
	$private_threads_setting_3 = array(
		"sid"			=> "NULL",
		"name"			=> "private_threads_forum",
		"title"			=> "الاقسام الخاصه",
		"description"	=> "ضع هنا ارقام الاقسام المراد عد امكانية الرد من قبل مجموعات الاعضاء اللي تم وضعها بالاعلي.",
		"optionscode"	=> "text",
		"value"			=> "1,2,3",
		"disporder"		=> "3",
		"gid"			=> intval($gid),
	);

	$db->insert_query("settings", $private_threads_setting_3);

	rebuild_settings();
}

function private_threads_is_installed()
{
	global $db;
	$query = $db->simple_select("settinggroups", "COUNT(*) as rows", "name='private_threads'");
	$rows = $db->fetch_field($query, "rows");
	if($rows > 0)
	{
		return TRUE;
	}
	
	return FALSE;
}

function private_threads_activate()
{
}

function private_threads_deactivate()
{
}

function private_threads_uninstall()
{
	global $db, $mybb;
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='private_threads'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='private_threads_power'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='private_threads_group'");
    rebuild_settings();
}

$plugins->add_hook("newreply_start", "private_threads");
$plugins->add_hook("newreply_do_newreply_start", "private_threads");
function private_threads()
{
	global $mybb, $thread, $lang;
	$power = $mybb->settings['private_threads_power'];
	$groups = explode(",",$mybb->settings['private_threads_group']);
	$forums = explode(",",$mybb->settings['private_threads_forum']);
	
	if ($power != "0" && in_array($mybb->user['usergroup'],$groups) && in_array($thread['fid'],$forums) && $mybb->user['uid'] != $thread['uid'])
	{
		$lang->load("private_threads");
		error($lang->error_no_permission);
	}
}

$plugins->add_hook("showthread_end", "private_threads_quickreply");
function private_threads_quickreply()
{
	global $mybb, $thread, $templates, $quickreply;
	$power = $mybb->settings['private_threads_power'];
	$groups = explode(",",$mybb->settings['private_threads_group']);
	$forums = explode(",",$mybb->settings['private_threads_forum']);
	
	if ($power != "0" && in_array($mybb->user['usergroup'],$groups) && in_array($thread['fid'],$forums) && $mybb->user['uid'] != $thread['uid'])
	{
		$quickreply = '';
	}
}
?>